<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsltc="http://xml.apache.org/xalan/xsltc"
                xmlns:java="http://xml.apache.org/xslt/java" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="xs fn java">
    <xsl:param name="context" xml:base="it.infocamere.suap.sufo.ejb.transform.helpers.DBEnvironment"/>
    <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
    <xsl:template match="/pratica">
        <mvarstruttaa:modulo_variazione_strutture_aria_aperta
                xmlns:ccts-cct="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2"
                xmlns:ccts="urn:un:unece:uncefact:documentation:2"
                xmlns:mvarstruttaa="../04_forms/strutture_aria_aperta_variazione"
                xmlns:sanagatt="../03_section/anagrafica_attivita"
                xmlns:eanagstruttacc="../02_entities/anagrafica_attivita"
                xmlns:edaca="../02_entities/dati_catastali"
                xmlns:svarstruttaa="../03_section/strutt_aria_aperta_variazione"
                xmlns:evaraa="../02_entities/variazioni_attivita_strutt_aria_aperta"
                xmlns:sinfostruttaa="../03_section/info_strutture_aria_aperta"
                xmlns:enomrap="../02_entities/nomina_rappresentante"
                xmlns:edotstruttaa="../02_entities/dotazioni_struttura_aria_aperta"
                xmlns:ecapricstruttaa="../02_entities/capacita_ricettiva_strutt_aria_aperta"
                xmlns:srdocstruttaa="../03_section/riepilogo_documentazione_strutture_aria_aperta"
                xmlns:einfoprivacy="../02_entities/informativa_privacy"
                xmlns:sschedaanag="../03_section/scheda_anagrafica" xmlns:epers="../02_entities/persona"
                xmlns:ecitt="../02_entities/cittadinanza"
                xmlns:edocril="../02_entities/documento_rilasciato"
                xmlns:eindita="../02_entities/indirizzo_italiano"
                xmlns:eindest="../02_entities/indirizzo_estero" xmlns:econt="../02_entities/contatti"
                xmlns:erapp="../02_entities/rappresentanza" xmlns:eimpresa="../02_entities/impresa"
                xmlns:edomdig="../02_entities/domicilio_digitale"
                xmlns:eiscrea="../02_entities/iscrizione_REA">
            <xsl:call-template name="HANAGRAFICA">
                <xsl:with-param name="input" select="/pratica"/>
            </xsl:call-template>
            <xsl:call-template name="VARIAZIONE">
                <xsl:with-param name="input" select="/pratica"/>
            </xsl:call-template>
            <xsl:call-template name="DOCUMENTAZIONE">
                <xsl:with-param name="input" select="/pratica"/>
            </xsl:call-template>
        </mvarstruttaa:modulo_variazione_strutture_aria_aperta>
    </xsl:template>

    <xsl:template name="DOCUMENTAZIONE">
        <xsl:param name="input"/>
        <mvarstruttaa:sezione_riepilogo_documentazione_strutture_aria_aperta
                xmlns:mvarstruttaa="../04_forms/strutture_aria_aperta_variazione"
                xmlns:srdocstruttaa="../03_section/riepilogo_documentazione_strutture_aria_aperta">
            <xsl:if test="$input/informativaprivacy/accettazione_privacy/@code = 1">
                <srdocstruttaa:informativa_privacy_check> true
                </srdocstruttaa:informativa_privacy_check>
            </xsl:if>
            <srdocstruttaa:informativa_privacy
                    xmlns:einfoprivacy="../02_entities/informativa_privacy">
                <einfoprivacy:comune>
                    <xsl:value-of select="$input/struttura/sportello/comune"/>
                </einfoprivacy:comune>
                <einfoprivacy:email_pec>
                    <xsl:value-of select="$input/struttura/sportello/pec"/>
                </einfoprivacy:email_pec>
                <einfoprivacy:responsabile_trattamento>
                    <xsl:value-of
                            select="concat($input/struttura/sportello/responsabile/nome, ' ', $input/struttura/sportello/responsabile/cognome)"
                    />
                </einfoprivacy:responsabile_trattamento>
                <einfoprivacy:comune_richieste>
                    <xsl:value-of select="$input/struttura/sportello/comune"/>
                </einfoprivacy:comune_richieste>
                <einfoprivacy:mail>
                    <xsl:value-of select="$input/struttura/sportello/pec"/>
                </einfoprivacy:mail>
            </srdocstruttaa:informativa_privacy>

        </mvarstruttaa:sezione_riepilogo_documentazione_strutture_aria_aperta>
    </xsl:template>

    <xsl:template name="VARIAZIONE">
        <xsl:param name="input"/>

        <mvarstruttaa:sezione_anagrafica_attivita
                xmlns:mvarstruttaa="../04_forms/strutture_aria_aperta_variazione"
                xmlns:sanagatt="../03_section/anagrafica_attivita">

            <sanagatt:anagrafica_attivita xmlns:eanagstruttacc="../02_entities/anagrafica_attivita">
                <eanagstruttacc:via>
                    <xsl:value-of select="$input/DC616/Ndic1093_1"/>
                </eanagstruttacc:via>
                <eanagstruttacc:nCivico>
                    <xsl:value-of select="$input/DC616/Ndic1065_1"/>
                </eanagstruttacc:nCivico>
                <eanagstruttacc:comune>
                    <xsl:value-of select="$input/DC616/Ndic1041_1"/>
                </eanagstruttacc:comune>
                <eanagstruttacc:provincia>
                    <xsl:value-of select="$input/DC616/C12056"/>
                </eanagstruttacc:provincia>
                <eanagstruttacc:cap>
                    <xsl:value-of select="$input/DC616/Ndic1040_1"/>
                </eanagstruttacc:cap>
            </sanagatt:anagrafica_attivita>
            <sanagatt:dati_catastali xmlns:edaca="../02_entities/dati_catastali">
                <edaca:foglio>
                    <xsl:value-of select="$input/DATI_CATASTALI/repeats_TF/repeats/foglio"/>
                </edaca:foglio>
                <edaca:particella>
                    <xsl:value-of select="$input/DATI_CATASTALI/repeats_TF/repeats/particella"/>
                </edaca:particella>
                <edaca:subalterno>
                    <xsl:value-of select="$input/DATI_CATASTALI/repeats_TF/repeats/subalterno"/>
                </edaca:subalterno>
                <edaca:sezione>
                    <xsl:if test="$input/DATI_CATASTALI/repeats_TF/tipo/@code = 'NCT'">
                        <xsl:value-of select="$input/DATI_CATASTALI/sezioneAmministrativa"/>
                    </xsl:if>
                    <xsl:if test="$input/DATI_CATASTALI/repeats_TF/tipo/@code = 'NCEU'">
                        <xsl:value-of
                                select="concat($input/DATI_CATASTALI/repeats_TF/repeats/sezioneAmministrativa, $input/DATI_CATASTALI/repeats_TF/repeats/sezioneUrbana)"
                        />
                    </xsl:if>
                </edaca:sezione>
                <edaca:fabbricati>
                    <xsl:if test="$input/DATI_CATASTALI/repeats_TF/repeats/tipo/@code = 'NCEU'"> true
                    </xsl:if>
                </edaca:fabbricati>
            </sanagatt:dati_catastali>
        </mvarstruttaa:sezione_anagrafica_attivita>
        <mvarstruttaa:sezione_variazione_strutture_aria_aperta
                xmlns:mvarstruttaa="../04_forms/strutture_aria_aperta_variazione"
                xmlns:svarstruttaa="../03_section/strutt_aria_aperta_variazione">
            <svarstruttaa:variazione_strutture_aria_aperta
                    xmlns:evaraa="../02_entities/variazioni_attivita_strutt_aria_aperta">
                <evaraa:nr_protocollo>
                    <xsl:value-of select="$input/var_alberghiere/num_prot"/>
                </evaraa:nr_protocollo>
                <evaraa:data_protocollo>
                    <xsl:value-of select="$input/var_alberghiere/data_prot"/>
                </evaraa:data_protocollo>

                <xsl:if test="$input/var_alberghiere/var_capacita/@code = '1'">
                    <evaraa:variazione_posti_letto>true</evaraa:variazione_posti_letto>
                    <evaraa:posti_letto_ante>
                        <xsl:value-of select="$input/var_alberghiere/capacita_old"/>
                    </evaraa:posti_letto_ante>
                    <evaraa:posti_letto_post>
                        <xsl:value-of select="$input/var_alberghiere/capacita_new"/>
                    </evaraa:posti_letto_post>
                </xsl:if>
                <xsl:if test="$input/var_alberghiere/var_dotazioni/@code = '2'">
                    <evaraa:variazione_dotazioni>true</evaraa:variazione_dotazioni>
                    <evaraa:dotazioni_ante>
                        <xsl:value-of select="$input/var_alberghiere/capacita_old"/>
                    </evaraa:dotazioni_ante>
                    <evaraa:dotazioni_post>
                        <xsl:value-of select="$input/var_alberghiere/capacita_new"/>
                    </evaraa:dotazioni_post>
                </xsl:if>
                <xsl:if test="$input/var_alberghiere/var_classificazione/@code = '3'">
                    <evaraa:variazione_classificazione>true</evaraa:variazione_classificazione>
                    <evaraa:classificazione_ante>
                        <xsl:value-of select="$input/var_alberghiere/classificazione_old"/>
                    </evaraa:classificazione_ante>
                    <evaraa:classificazione_post>
                        <xsl:value-of select="$input/var_alberghiere/classificazione_new"/>
                    </evaraa:classificazione_post>
                </xsl:if>
                <xsl:if test="$input/var_alberghiere/ampliamento/@code = '5'">
                    <evaraa:ampliamento>true</evaraa:ampliamento>
                    <evaraa:metratura_ante><xsl:value-of select="$input/var_alberghiere/mq_old"/></evaraa:metratura_ante>
                    <evaraa:metratura_post><xsl:value-of select="$input/var_alberghiere/mq_new"/></evaraa:metratura_post>
                </xsl:if>
                <xsl:if test="$input/var_alberghiere/altre_variazioni/@code = '4'">
                    <evaraa:altre_variazioni>true</evaraa:altre_variazioni>
                    <evaraa:tipo_altra_variazione>
                        <xsl:value-of select="$input/var_alberghiere/tipo_altre_var"/>
                    </evaraa:tipo_altra_variazione>
                    <evaraa:altra_variazione_ante>
                        <xsl:value-of select="$input/var_alberghiere/altre_da"/>
                    </evaraa:altra_variazione_ante>
                    <evaraa:altra_vatazione_post>
                        <xsl:value-of select="$input/var_alberghiere/altre_a"/>
                    </evaraa:altra_vatazione_post>
                </xsl:if>

            </svarstruttaa:variazione_strutture_aria_aperta>
        </mvarstruttaa:sezione_variazione_strutture_aria_aperta>


        <mvarstruttaa:sezione_info_strutture_aria_aperta
                xmlns:mvarstruttaa="../04_forms/strutture_aria_aperta_variazione"
                xmlns:sinfostruttaa="../03_section/info_strutture_aria_aperta">
            <!-- NOMINA RAPPRESENTANTE -->
            <xsl:if test="$input/StruttureRicettive_NominaRappresentante">
                <sinfostruttaa:nomina_rappresentante
                        xmlns:enomrap="../02_entities/nomina_rappresentante">
                    <enomrap:nome>
                        <xsl:value-of
                                select="$input/StruttureRicettive_NominaRappresentante/RappresentanteTulpsArt93/rappresentante_nome"
                        />
                    </enomrap:nome>
                    <enomrap:cognome>
                        <xsl:value-of
                                select="$input/StruttureRicettive_NominaRappresentante/RappresentanteTulpsArt93/rappresentante_nome"
                        />
                    </enomrap:cognome>
                </sinfostruttaa:nomina_rappresentante>
            </xsl:if>
            <!-- DOTAZIONI STRUTTURA -->
            <sinfostruttaa:dotazioni_struttura
                    xmlns:edotstruttaa="../02_entities/dotazioni_struttura_aria_aperta">

                <xsl:if
                        test="$input/StruttureRicettiveAriaAperta_Avvio_ServiziStruttura/marchiqualita/@code = '1'">
                    <edotstruttaa:marchi_qualita>true</edotstruttaa:marchi_qualita>
                </xsl:if>
                <!--somministrazione alimenti -->
                <xsl:if
                        test="$input/StruttureRicettiveAriaAperta_Avvio_ServiziStruttura/somministrazioneAlimenti/@code = '1'">
                    <edotstruttaa:no_alimenti>true</edotstruttaa:no_alimenti>
                </xsl:if>
                <xsl:if
                        test="$input/StruttureRicettiveAriaAperta_Avvio_ServiziStruttura/somministrazioneAlimenti/@code = '2'">
                    <edotstruttaa:somministrazione_allogiati>true</edotstruttaa:somministrazione_allogiati>
                </xsl:if>
                <xsl:if
                        test="$input/StruttureRicettiveAriaAperta_Avvio_ServiziStruttura/somministrazioneAlimenti/@code = '3'">
                    <edotstruttaa:somministrazione_pubblica>true</edotstruttaa:somministrazione_pubblica>
                </xsl:if>
                <!--piscina -->
                <xsl:if test="$input/dotazioni_extra/piscina/@code = '4'">
                    <edotstruttaa:no_pisicina>true</edotstruttaa:no_pisicina>
                </xsl:if>
                <xsl:if
                        test="$input/StruttureRicettiveAriaAperta_Avvio_ServiziStruttura/piscina/@code = '5'">
                    <edotstruttaa:piscina_allogiati>true</edotstruttaa:piscina_allogiati>
                    <edotstruttaa:nr_impianti_piscina_allogiati>
                        <xsl:value-of
                                select="$input/StruttureRicettiveAriaAperta_Avvio_ServiziStruttura/impiantiperClienti_nr"
                        />
                    </edotstruttaa:nr_impianti_piscina_allogiati>
                    <edotstruttaa:misura_impianti_piscina_allogiati>
                        <xsl:value-of
                                select="$input/StruttureRicettiveAriaAperta_Avvio_ServiziStruttura/impiantiperClienti/mqImpianto"
                        />
                    </edotstruttaa:misura_impianti_piscina_allogiati>
                </xsl:if>
                <xsl:if
                        test="$input/StruttureRicettiveAriaAperta_Avvio_ServiziStruttura/piscina/@code = '6'">
                    <edotstruttaa:piscina_pubblica>true</edotstruttaa:piscina_pubblica>
                    <edotstruttaa:nr_impianti_piscina_pubblica>
                        <xsl:value-of
                                select="$input/StruttureRicettiveAriaAperta_Avvio_ServiziStruttura/ImpiantiAlPubblico_nr"
                        />
                    </edotstruttaa:nr_impianti_piscina_pubblica>
                    <edotstruttaa:misura_impianti_piscina_pubblica>
                        <xsl:value-of
                                select="$input/StruttureRicettiveAriaAperta_Avvio_ServiziStruttura/ImpiantiAlPubblico/mqImpianto"
                        />
                    </edotstruttaa:misura_impianti_piscina_pubblica>
                </xsl:if>

                <!--centro benessere -->
                <xsl:if
                        test="$input/StruttureRicettiveAriaAperta_Avvio_ServiziStruttura/centroBenessere/@code = '7'">
                    <edotstruttaa:no_centro_estetico>true</edotstruttaa:no_centro_estetico>
                </xsl:if>
                <xsl:if
                        test="$input/StruttureRicettiveAriaAperta_Avvio_ServiziStruttura/centroBenessere/@code = '8'">
                    <edotstruttaa:centro_estetico_allogiati>true</edotstruttaa:centro_estetico_allogiati>
                </xsl:if>
                <xsl:if
                        test="$input/StruttureRicettiveAriaAperta_Avvio_ServiziStruttura/centroBenessere/@code = '9'">
                    <edotstruttaa:centro_estetico_pubblico>true</edotstruttaa:centro_estetico_pubblico>
                </xsl:if>
                <!-- palestra -->
                <xsl:if
                        test="$input/StruttureRicettiveAriaAperta_Avvio_ServiziStruttura/palestra/@code = '10'">
                    <edotstruttaa:no_palestra>true</edotstruttaa:no_palestra>
                </xsl:if>
                <xsl:if
                        test="$input/StruttureRicettiveAriaAperta_Avvio_ServiziStruttura/palestra/@code = '11'">
                    <edotstruttaa:palestra_allogiati>true</edotstruttaa:palestra_allogiati>
                </xsl:if>
                <xsl:if
                        test="$input/StruttureRicettiveAriaAperta_Avvio_ServiziStruttura/palestra/@code = '12'">
                    <edotstruttaa:palestra_pubblica>true</edotstruttaa:palestra_pubblica>
                </xsl:if>
                <!-- altro -->
                <xsl:if test="$input/dotazioni_extra/altro">
                    <edotstruttaa:altro>
                        <xsl:value-of
                                select="$input/StruttureRicettiveAriaAperta_Avvio_ServiziStruttura/altro"
                        />
                    </edotstruttaa:altro>
                </xsl:if>
                <edotstruttaa:servizio_1>
                    <xsl:value-of
                            select="$input/StruttureRicettiveAriaAperta_Avvio_ServiziStruttura/descrizioneServizio"
                    />
                </edotstruttaa:servizio_1>
                <edotstruttaa:gestore_1>
                    <xsl:value-of
                            select="$input/StruttureRicettiveAriaAperta_Avvio_ServiziStruttura/gestore"
                    />
                </edotstruttaa:gestore_1>
            </sinfostruttaa:dotazioni_struttura>
            <!--CAPACITA RICETTIVA-->
            <sinfostruttaa:capacita_ricettiva
                    xmlns:ecapric="../02_entities/capacita_ricettiva_strutt_aria_aperta">
                <ecapric:capacita_ricettiva_max>
                    <xsl:value-of
                            select="$input/StruttureRicettiveAriaAperta_Avvio_Capacita/capacitaRicettivaMassima"
                    />
                </ecapric:capacita_ricettiva_max>
                <ecapric:piazzole_libere>
                    <xsl:value-of select="$input/StruttureRicettiveAriaAperta_Avvio_Capacita/libere"
                    />
                </ecapric:piazzole_libere>
                <ecapric:piazzole_attrezzate>
                    <xsl:value-of
                            select="$input/StruttureRicettiveAriaAperta_Avvio_Capacita/attrezzate"/>
                </ecapric:piazzole_attrezzate>
                <!--Unità abitative -->
                <ecapric:unita_abitative_fisse>
                    <xsl:value-of select="$input/StruttureRicettiveAriaAperta_Avvio_Capacita/unita"
                    />
                </ecapric:unita_abitative_fisse>
                <ecapric:posti_letto>
                    <xsl:value-of
                            select="$input/StruttureRicettiveAriaAperta_Avvio_Capacita/postiLettoComplessivi"
                    />
                </ecapric:posti_letto>

                <!-- <ecapric:nr_stessa_unita>
                    <xsl:value-of
                        select="$input/StruttureRicettiveAriaAperta_Avvio_Capacita/tipologia/unitaStessoTipo"
                    />
                </ecapric:nr_stessa_unita>
                <ecapric:monolocali>
                    <xsl:value-of
                        select="$input/StruttureRicettiveAriaAperta_Avvio_Capacita/tipologia/postiLettoComplessivi"
                    />
                </ecapric:monolocali>
                <ecapric:multilocali>
                    <xsl:value-of
                        select="$input/StruttureRicettiveAriaAperta_Avvio_Capacita/postiLettoComplessivi"
                    />
                </ecapric:multilocali>
                <ecapric:camere_pernottamento>
                    <xsl:value-of
                        select="$input/StruttureRicettiveAriaAperta_Avvio_Capacita/nrCamere"/>
                </ecapric:camere_pernottamento>
                <ecapric:soggiorno_vano_pernottamento>
                    <xsl:value-of
                        select="$input/StruttureRicettiveAriaAperta_Avvio_Capacita/postiLettoComplessivi"
                    />
                </ecapric:soggiorno_vano_pernottamento>
                <ecapric:soggiorno_separato>
                    <xsl:value-of
                        select="$input/StruttureRicettiveAriaAperta_Avvio_Capacita/soggiorno"/>
                </ecapric:soggiorno_separato>
                <ecapric:cucina_vano_separato>
                    <xsl:value-of
                        select="$input/StruttureRicettiveAriaAperta_Avvio_Capacita/cucinaInVanoSeparato"
                    />
                </ecapric:cucina_vano_separato>
                <ecapric:bagni_privati>
                    <xsl:value-of
                        select="$input/StruttureRicettiveAriaAperta_Avvio_Capacita/bagniPrivati"/>
                </ecapric:bagni_privati>
                <ecapric:nr_posti_letto>
                    <xsl:value-of
                        select="$input/StruttureRicettiveAriaAperta_Avvio_Capacita/totalePostiLetto"
                    />
                </ecapric:nr_posti_letto>-->

            </sinfostruttaa:capacita_ricettiva>
        </mvarstruttaa:sezione_info_strutture_aria_aperta>

        <!-- ALTRE DICHIARAZIONI -->

        <mvarstruttaa:altre_dichiarazioni
                xmlns:mvarstruttaa="../04_forms/strutture_aria_aperta_variazione">
            <xsl:value-of select="$input/StruttureRicettiveAriaAperta_altreDichiarazioni/altro"/>
        </mvarstruttaa:altre_dichiarazioni>

    </xsl:template>

    <xsl:template name="HANAGRAFICA">
        <xsl:param name="input"/>
        <mvarstruttaa:scheda_anagrafica
                xmlns:mvarstruttaa="../04_forms/strutture_aria_aperta_variazione"
                xmlns:sschedaanag="../03_section/scheda_anagrafica">

            <sschedaanag:datiDichiarante xmlns:epers="../02_entities/persona">
                <epers:cognome>
                    <xsl:value-of select="$input/HANAGRAFICA/ANAG_LEGALE_RAPPRESENTANTE_COGNOME"/>
                </epers:cognome>
                <epers:nome>
                    <xsl:value-of select="$input/HANAGRAFICA/ANAG_LEGALE_RAPPRESENTANTE_NOME"/>
                </epers:nome>
                <epers:codiceFiscale>
                    <xsl:value-of
                            select="translate($input/HANAGRAFICA/ANAG_LEGALE_RAPPRESENTANTE_CODFISC, 'abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"
                    />
                </epers:codiceFiscale>
                <epers:sesso>
                    <xsl:value-of select="$input/HANAGRAFICA/ANAG_LEGALE_RAPPRESENTANTE_SESSO/@code"
                    />
                </epers:sesso>
                <epers:comuneNascita>
                    <xsl:value-of
                            select="$input/HANAGRAFICA/INDIRIZZO_STANDARD_NASCITA/COMUNE_STANDARD"/>
                </epers:comuneNascita>
                <epers:provinciaNascita>
                    <xsl:value-of
                            select="$input/HANAGRAFICA/INDIRIZZO_STANDARD_NASCITA/PROVINCIA_STANDARD"/>
                </epers:provinciaNascita>
                <epers:statoNascita>
                    <xsl:value-of
                            select="$input/HANAGRAFICA/INDIRIZZO_STANDARD_NASCITA/STATO_STANDARD"/>
                </epers:statoNascita>
                <epers:dataNascita>
                    <xsl:value-of select="$input/HANAGRAFICA/ANAG_LEGALE_RAPPRESENTANTE_DATANASCITA"
                    />
                </epers:dataNascita>
            </sschedaanag:datiDichiarante>
            <sschedaanag:cittadinanza xmlns:ecitt="../02_entities/cittadinanza">
                <ecitt:stato_cittadinanza>
                    <xsl:value-of
                            select="$input/HANAGRAFICA/ANAG_LEGALE_RAPPRESENTANTE_CITTADINANZA"/>
                </ecitt:stato_cittadinanza>
            </sschedaanag:cittadinanza>
            <sschedaanag:residenza_dichiarante xmlns:eindita="../02_entities/indirizzo_italiano">
                <eindita:comune>
                    <xsl:value-of
                            select="$input/HANAGRAFICA/INDIRIZZO_STANDARD_RESIDENZA/COMUNE_STANDARD"/>
                </eindita:comune>
                <eindita:provincia>
                    <xsl:value-of
                            select="$input/HANAGRAFICA/INDIRIZZO_STANDARD_RESIDENZA/PROVINCIA_STANDARD"
                    />
                </eindita:provincia>
                <eindita:stato>
                    <xsl:value-of
                            select="$input/HANAGRAFICA/INDIRIZZO_STANDARD_RESIDENZA/STATO_STANDARD"/>
                </eindita:stato>
                <eindita:dug>
                    <xsl:value-of select="$input/HANAGRAFICA/ANAG_LEGALE_RAPPRESENTANTE_TOPORES"/>
                </eindita:dug>
                <eindita:toponimo>
                    <xsl:value-of select="$input/HANAGRAFICA/ANAG_LEGALE_RAPPRESENTANTE_DENOMSTRES"
                    />
                </eindita:toponimo>
                <eindita:numero_civico>
                    <xsl:value-of select="$input/HANAGRAFICA/ANAG_NUM_N_RESIDENZA"/>
                </eindita:numero_civico>
                <eindita:cap>
                    <xsl:value-of select="$input/HANAGRAFICA/ANAG_LEGALE_RAPPRESENTANTE_CAPRES"/>
                </eindita:cap>
            </sschedaanag:residenza_dichiarante>
            <sschedaanag:contatti_dichiarante xmlns:econt="../02_entities/contatti">
                <econt:telefono_fisso>
                    <xsl:value-of select="$input/HANAGRAFICA/ANAG_LEGALE_RAPPRESENTANTE_TELRES"/>
                </econt:telefono_fisso>
            </sschedaanag:contatti_dichiarante>
            <sschedaanag:rappresentanza_dichiarante xmlns:erapp="../02_entities/rappresentanza">
                <xsl:if test="$input/HANAGRAFICA/ANAG_LEGALE_RAPPRESENTANTE_CARICA">
                    <erapp:ruolo>
                        <xsl:value-of select="$input/HANAGRAFICA/ANAG_LEGALE_RAPPRESENTANTE_CARICA"
                        />
                    </erapp:ruolo>
                </xsl:if>
                <xsl:if test="$input/HANAGRAFICA/ANAG_CARICA_PERSONA">
                    <erapp:ruolo>
                        <xsl:value-of select="$input/HANAGRAFICA/ANAG_CARICA_PERSONA"/>
                    </erapp:ruolo>
                </xsl:if>
            </sschedaanag:rappresentanza_dichiarante>
            <xsl:if test="$input/HANAGRAFICA/ANAG_RAD_PERSONA_IMPRESA/@code = '2'">
                <sschedaanag:impresa xmlns:eimpresa="../02_entities/impresa">
                    <eimpresa:denominazione>
                        <xsl:value-of select="$input/HANAGRAFICA/ANAG_RAPPSOC_DENOM"/>
                    </eimpresa:denominazione>
                    <eimpresa:forma_giuridica>
                        <xsl:value-of select="$input/HANAGRAFICA/ANAG_RAPPSOC_FORGIU"/>
                    </eimpresa:forma_giuridica>
                    <eimpresa:codice_fiscale>
                        <xsl:value-of select="$input/HANAGRAFICA/ANAG_RAPPSOC_CODFISC"/>
                    </eimpresa:codice_fiscale>
                    <eimpresa:partita_iva>
                        <xsl:value-of select="$input/HANAGRAFICA/ANAG_RAPPSOC_PIVA"/>
                    </eimpresa:partita_iva>
                    <xsl:if test="$input/HANAGRAFICA/ANAG_RAD_IMPRESA_ISCRIZIONE/@code = '3'">
                        <eimpresa:iscritto_rea_check> true </eimpresa:iscritto_rea_check>
                        <eimpresa:rea xmlns:eiscrea="../02_entities/iscrizione_REA">
                            <eiscrea:CCIAA>
                                <xsl:value-of select="$input/HANAGRAFICA/ANAG_RAPPSOC_PROVREA"/>
                            </eiscrea:CCIAA>
                            <eiscrea:numero_REA>
                                <xsl:value-of select="$input/HANAGRAFICA/ANAG_RAPPSOC_NUMEROREA"/>
                            </eiscrea:numero_REA>
                        </eimpresa:rea>
                    </xsl:if>
                    <xsl:if test="$input/HANAGRAFICA/ANAG_RAD_IMPRESA_ISCRIZIONE/@code = '4'">
                        <eimpresa:non_iscritto_rea> true </eimpresa:non_iscritto_rea>
                    </xsl:if>
                    <xsl:if test="$input/HANAGRAFICA/ANAG_RAD_IMPRESA_ISCRIZIONE/@code = '5'">
                        <eimpresa:solo_ri_rea> true </eimpresa:solo_ri_rea>
                    </xsl:if>
                    <eimpresa:indirizzo_attivita xmlns:eindita="../02_entities/indirizzo_italiano">
                        <eindita:comune>
                            <xsl:value-of
                                    select="$input/HANAGRAFICA/INDIRIZZO_STANDARD_SEDE_LEGALE/COMUNE_STANDARD"
                            />
                        </eindita:comune>
                        <eindita:provincia>
                            <xsl:value-of
                                    select="$input/HANAGRAFICA/INDIRIZZO_STANDARD_SEDE_LEGALE/PROVINCIA_STANDARD"
                            />
                        </eindita:provincia>
                        <eindita:stato>
                            <xsl:value-of
                                    select="$input/HANAGRAFICA/INDIRIZZO_STANDARD_SEDE_LEGALE/STATO_STANDARD"
                            />
                        </eindita:stato>
                        <eindita:dug>
                            <xsl:value-of select="$input/HANAGRAFICA/ANAG_RAPPSOC_SL_TOPONIMO"/>
                        </eindita:dug>
                        <eindita:toponimo>
                            <xsl:value-of
                                    select="$input/HANAGRAFICA/ANAG_LEGALE_RAPPRESENTANTE_DENOMSTRES"/>
                        </eindita:toponimo>
                        <eindita:numero_civico>
                            <xsl:value-of select="$input/HANAGRAFICA/ANAG_RAPPSOC_SL_NUMEROCIVICO"/>
                        </eindita:numero_civico>
                        <eindita:cap>
                            <xsl:value-of select="$input/HANAGRAFICA/ANAG_RAPPSOC_CAPSEDE"/>
                        </eindita:cap>
                    </eimpresa:indirizzo_attivita>
                    <eimpresa:telefono_cellulare>
                        <xsl:value-of select="$input/HANAGRAFICA/ANAG_RAPPSOC_TELSEDE"/>
                    </eimpresa:telefono_cellulare>
                </sschedaanag:impresa>
            </xsl:if>
            <xsl:if test="$input/HPROCURA">

                <sschedaanag:datiProcuratore xmlns:epers="../02_entities/persona">
                    <epers:cognome>
                        <xsl:value-of select="$input/HPROCURA/ANAG_PROCURATORE_COGNOME"/>
                    </epers:cognome>
                    <epers:nome>
                        <xsl:value-of select="$input/HPROCURA/ANAG_PROCURATORE_NOME"/>
                    </epers:nome>
                    <epers:codiceFiscale>
                        <xsl:value-of
                                select="translate($input/HPROCURA/ANAG_PROCURATORE_CODFISC, 'abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"
                        />
                    </epers:codiceFiscale>
                    <epers:sesso>
                        <xsl:value-of select="$input/HPROCURA/ANAG_PROCURATORE_SESSO/@code"/>
                    </epers:sesso>
                    <epers:comuneNascita>
                        <xsl:value-of select="$input/HPROCURA/ANAG_PROCURATORE_COMUNENASCITA"/>
                    </epers:comuneNascita>
                    <epers:provinciaNascita>
                        <xsl:value-of select="$input/HPROCURA/ANAG_PROCURATORE_PROVNASCITA"/>
                    </epers:provinciaNascita>
                    <epers:dataNascita>
                        <xsl:value-of select="$input/HPROCURA/ANAG_PROCURATORE_DATANASCITA"/>
                    </epers:dataNascita>
                </sschedaanag:datiProcuratore>
                <sschedaanag:residenza_procuratore xmlns:eindita="../02_entities/indirizzo_italiano">
                    <eindita:comune>
                        <xsl:value-of select="$input/HPROCURA/ANAG_PROCURATORE_COMUNERES"/>
                    </eindita:comune>
                    <eindita:provincia>
                        <xsl:value-of select="$input/HPROCURA/ANAG_PROCURATORE_PROVRES"/>
                    </eindita:provincia>
                    <eindita:toponimo>
                        <xsl:value-of select="$input/HPROCURA/ANAG_PROCURATORE_VIARES"/>
                    </eindita:toponimo>
                    <eindita:cap>
                        <xsl:value-of select="$input/HPROCURA/ANAG_PROCURATORE_CAPRES"/>
                    </eindita:cap>
                </sschedaanag:residenza_procuratore>
                <sschedaanag:contatti_procuratore xmlns:econt="../02_entities/contatti">
                    <econt:telefono_fisso>
                        <xsl:value-of select="$input/HANAGRAFICA/ANAG_LEGALE_RAPPRESENTANTE_TELRES"
                        />
                    </econt:telefono_fisso>
                </sschedaanag:contatti_procuratore>
                <sschedaanag:denominazione>
                    <xsl:value-of select="$input/HPROCURA/ANAG_PROCURATORE_QUALIFICA"/>
                </sschedaanag:denominazione>
            </xsl:if>
            <sschedaanag:domicilio_digitale xmlns:edomdig="../02_entities/domicilio_digitale">
                <xsl:if test="$input/DOMICILIO_DIGITALE/INAD">
                    <edomdig:domicilio_inad_check> true </edomdig:domicilio_inad_check>
                    <edomdig:domicilio_inad_string>
                        <xsl:value-of select="$input/DOMICILIO_DIGITALE/DOMICILIO_DIGITALE_PERSONA"
                        />
                    </edomdig:domicilio_inad_string>
                </xsl:if>
                <xsl:if test="$input/DOMICILIO_DIGITALE/INI_PEC">
                    <edomdig:domicilio_ini_pec_check> true </edomdig:domicilio_ini_pec_check>
                    <edomdig:domicilio_ini_pec_string>
                        <xsl:value-of select="$input/DOMICILIO_DIGITALE/DOMICILIO_DIGITALE_IMPRESA"
                        />
                    </edomdig:domicilio_ini_pec_string>
                </xsl:if>
            </sschedaanag:domicilio_digitale>
        </mvarstruttaa:scheda_anagrafica>

    </xsl:template>
</xsl:stylesheet>
